'library source

/*
Look after this file And keep backups!
It is awkward to maintain the Library without it.

How to use this file:
1 . Make your changes in the editor
2 . Save it - A VERY IMPORTANT STEP!!!
3 . At the command line LIBRARY DELETE
4 . At the command line LIBRARY SAVE
The revised library is now active - and has disappeared from the editor.

You did remember step 2, didn't you??

You can add SUBs etc directly to the library without using this file
but I don't recommend it as making deletions or other changes in the
library is a bit of a pain as you have lost all the lovely comments.
*/


Sub mm.startup 'This runs automatically once only on power up/reset
  Local i
  'The following puts unused pins into a stable state for the RP2350
  For i=1 To 40
   If MM.Info(pin i)="OFF" Then SetPin i, DIN, PULLUP
  Next

  SetPin gp20, dout

  led 2,1,4  'make it a pretty colour. :)
  Print "== PicoGAME 2350 GAMMA =="
  Print "F1: Help   F2: Run   F3 List   F4: Editor   F5:CLS"
  Print "F10: Autosave  F11: XMODEM Receive  F12: XMODEM Send"
  Print
End Sub

Sub led(r,g,b) 'corrects for weird red/grn swapped LED
  Device ws2812 b, gp20, 1, RGB(g,r,b)
End Sub

Function BitSet(num,bit) 'set bit in number
  bitset = num Or 1<<bit
End Function

Function BitRes(num,bit) 'reset bit in number
  bitres = num And INV(1<<bit)
End Function

Function BitTest(num,bit) 'returns 1 if bit is set else returns 0
  bittest = Abs(Sgn(num And 1<<bit))
End Function

Function iRND(max)
 irnd=Int(Rnd*(max+1))
End Function


' ------------------------ TERMINAL GRAPHICS ROUTINES --------------------------
' Vcls            clear screen
' Vch             cursor home to top left
' Vat row col     move cursor to row,column
' Vbox x,y,w,h,t  draw a box width w height h at x,y using 'Terminal' font box characters.
'                 t=0 for single line, 1 for double
' Vl y,x,l,t      draw a horizotal or vertical line to divide a box.
'                 l is length, t=0 for single line, 1 for double, negative for horizontal
' Vatt n$         set text attributes to n$ - none b /b in /in low u /u
'                 (none,bold,inverse,low_intensity,underlined)
' Vfc n$          set text/foreground colour by name or str$(number) 0-15
' Vbc n$          set background colour by name or str$(number) 0-16 (16 is light grey)
'                 Colours names are black, red, green, yellow, blue, magenta, cyan, white, grey
' ch              print the Escape sequence 'Chr$27 [' - used internally"

Sub ch:Print Chr$(27);"[";:End Sub

Sub Vcls:ch:Print "2J";:End Sub

Sub Vch:ch:Print "H";:End Sub

Sub Vclearhome
 Local k$
 k$=Chr$(27)+"[2J"+Chr$(27)+"[H"
 Print k$;
End Sub

Sub Vat(row,col)
Local k$
k$=Str$(row)+";"+Str$(col)+"H":ch:Print k$;
End Sub

Sub Vbox(row,col,w,h,t) 'daw a box in "Terminal" font box chars
 Local i
  Vat row,col
  If t=0 Then
   Print Chr$(218);String$(w-2,196);Chr$(191);
   Vat row+h,col
   Print Chr$(192);String$(w-2,196);Chr$(217);
   For i=1 To h-1
    Vat row+i,col:Print Chr$(179);
    Vat row+i,col+w-1:Print Chr$(179);
   Next
  Else
   Print Chr$(201);String$(w-2,205);Chr$(187);
   Vat row+h,col
   Print Chr$(200);String$(w-2,205);Chr$(188);
   For i=1 To h-1
    Vat row+i,col:Print Chr$(186);
    Vat row+i,col+w-1:Print Chr$(186);
   Next
  EndIf
End Sub

Sub Vl(row,col,l,t) 'draw a vertical or horizontal line to divide a box
 Local i,m
 m=t:t=Abs(t)
 If m>0 Then 'vertical line
  vat row,col: If t=0 Then Print Chr$(194); Else Print Chr$(203);
  vat row+l,col: If t=0 Then Print Chr$(193); Else Print Chr$(202);
  vat row+1,col
  For i=1 To l-1
   vat row+i,col
   If t=0 Then Print Chr$(179); Else Print Chr$(186);
  Next
 Else  'horizontal line
  vat row,col
  If t=0 Then
    Print Chr$(195)String$(w-2,196)Chr$(180)
  Else
    Print Chr$(204)String$(w-2,205)Chr$(185)
  EndIf
 EndIf
End Sub

Sub Vatt(tatt$)  'set text attributes
 ch
 Select Case LCase$(tatt$)
  Case "none":Print "0m";
  Case "b":Print "1m";
  Case "/b":Print "22m";
  Case "in":Print "7m";
  Case "/in":Print "27m";
  Case "u":Print "4m";
  Case "/u":Print "24m";
 End Select
End Sub

Sub Vfc(color$)  'set text foreground colour        'if we have a colour number 0-15 then use it
 Local k$
 If Len(color$)<3 And Val(color$)<16 Then
  k$="38;5;"+color$+"m"
  ch
  Print k$
 Else
  ch
  Select Case LCase$(color$)  'otherwise use the colour name
   Case "black":Print "30m";
   Case "red":Print "31m";
   Case "green":Print "32m";
   Case "yellow":Print "33m";
   Case "blue":Print "34m";
   Case "magenta":Print "35m";
   Case "cyan":Print "36m";
   Case "white":Print "37m";
   Case "grey","gray":Print "90m";
  End Select
 EndIf
End Sub

Sub Vbc(color$)  'set text background colour
 Local k$        'if we have a colour number 0-15 then use it
 If Len(color$)<3 And Val(color$)<16 Then
  k$="48;5;"+color$+"m"
  ch
  Print k$
 ElseIf Val(color$)=16 Then
  k$="48:2:115:115:115m"
  ch
  Print k$
 Else
  ch
  Select Case LCase$(color$) 'otherwise use the colour name
   Case "black":Print "40m";
   Case "red":Print "41m";
   Case "green":Print "42m";
   Case "yellow":Print "43m";
   Case "blue":Print "44m";
   Case "magenta":Print "45m";
   Case "cyan":Print "46m";
   Case "white":Print "47m";
   Case "grey","gray":Print "100m";
   Case Else :Print "39m"; 'default background
  End Select
 EndIf
End Sub


'END OF NORMAL LIBRARY ROUTINES
'==========================================================



/*
The following section is the Help system.
Please do not add library routines after this point as they
may get lost in subsequent future changes.
*/



Sub help
  Local i,k$
  Print
  Print "Help catagories available are:"
  Print "[A]bout  [L]ibrary   [S]ound   [D]evice   [M]ath"
  Print "d[I]splays                     [U]tility  e[X]it"
  Do
   k$=Inkey$
  Loop Until Instr("AaLlSsDdMmIiUuXx",k$)
  Print
  Select Case LCase$(k$)
  Case "x"
   Exit Sub
  Case "a"
   Print "This Library-integrated Help system was developed by"
   Print "MIXTEL 90 of the Backshed forum. Basically, it gives"
   Print "a little help on library routines and a reminder for"
   Print "some of the MMBasic commands."
   Print "Ultimately it might be expanded to give an option for"
   Print "more verbose help using text from a file on SD card."
  Case "l"
   Print "[LIBRARY COMMANDS]"
   Print "LED redvalue%, greenvalue%, bluevalue%  - front panel LED"
   Print
   Print "The following V commands control the console display"
   Print "Vcls - clear screen"
   Print "Vch  - cursor home"
   Print "Vat row%,column%  -  console text version of Print@"
   Print "     row% & column% are character positions, not pixels."
   Print "Vl Y%, X%, length%, mode%  -  draw a line to divide a box"
   Print "     Position is in character positions. Mode is 0 for single, 1 for double"
   Print "Vbox Xpos%, Ypos%, width%, height%, mode%   -  draw a box"
   Print "     Position is in character positions. mode is 0 for single, 1 for double"
   Print "Vatt n$  -  set text attributes"
   Print "Vfc n$  -  set text foreground colour"
   Print "Vbc n$  -  set text background colour"
   Print
   Print "[LIBRARY FUNCTIONS]"
   Print "BitSet(number, bit%)  -  set a bit in number"
   Print "BitRes(number, bit%)  -  reset a bit in number"
   Print "BitTest(number,bit%)  -  returns 1 if bit set, 0 if not"
   Print "iRND(max)  -  returns a random integer between 0 & max inclusive"
  Case "s"
   Print "[SOUND COMMANDS]"
   Print "OPTION AUDIO DISABLE"
   Print "OPTION AUDIO leftchannelPWM, rightchannelPWM"
   Print "OPTION AUDIO SPI CSpin, CLKpin, MOSIpin"
   Print "OPTION AUDIO VS1053 CLKpin, MOSIpin, MISOpin, XCSpin,"
   Print "                    XDCSpin, XRSTpin"
   Print "PLAY TONE left [,right [,duration]]"
   Print "PLAY WAV file$ [,interrupt]"
   Print "PLAY MP3 file$ [,interrupt]"
   Print "PLAY FLAC file$ [.interrupt]"
   Print "PLAY MODFILE file$ [,interrupt]"
   Print "PLAY SOUND soundnum, channelnum, type [,frequency] [,volume]"
   Print "PLAY PAUSE"
   Print "PLAY RESUME"
   Print "PLAY STOP"
   Print "PLAY VOLUME left, right"
   Print
   Print "Additionally for VS1053:"
   Print "PLAY MIDIFILE file$ [,interrupt]"
   Print "PLAY MIDI"
   Print "PLAY MIDI CMD cmd%, data1% [,data2%]"
   Print "PLAY NOTE ON channel, note, velocity"
   Print "PLAY NOTE OFF channel, note [,velocity]"
   Print "PLAY HALT"
   Print "PLAY STREAM buffer%(), readpointer%, writepointer%"

  Case "d"
   Print "[DEVICE COMMANDS]"
   Print "[B]itstream   [C]amera  [H]umidity  [L]CD"
   Print "[S]erial  [W]II                     e[X]it"
   Do
    k$=Inkey$
   Loop Until Instr("BbCcHhLlSsWwXx",k$)
   Print
   Select Case LCase$(k$)
   Case "x"
    Exit Sub
   Case "b"
    Print "DEVICE BITSTREAM pinno, n_transitions, array%()"
   Case "c"
    Print "DEVICE CAMERA OPEN XLKpin, PLKpin, HSpin, VSCpin. RETpin, D0pin"
    Print "DEVICE CAMERA CAPTURE [scale [, x,y]]"
    Print "DEVICE CAMERA CLOSE"
    Print "DEVICE CAMERA CHANGE image%(), change! [, scale [, x,y]]"
    Print "DEVICE CAMERA TEST tnum"
    Print "DEVICE CAMERA REGISTER reg%, data%"
   Case "h"
    Print "DEVICE HUMID pin, tver, hvar [,DHT11]"
   Case "l"
    Print "DEVICE LCD INIT d4, d5, d6, d7, rs, en"
    Print "DEVICE LCD line, pos, text$"
    Print "DEVICE LCD CLEAR"
    Print "DEVICE LCD CLOSE"
    Print "DEVICE LCD CMD d1 [, d2[, etc]]"
    Print "DEVICE LCD DATA d1 [, d2[, etc]]"
   Case "s"
    Print "DEVICE SERIAL RX pin, baudrate, istring$, timeout, status% [,nbr][,terminator$]"
    Print "DEVICE SERIAL TX pin, baudrate, ostring$"
   Case "w"
    Print "[WII COMMANDS]"
    Print "DEVICE WII OPEN [,interrupt]"
    Print "DEVICE WII CLOSE"
    Print
    Print "[WII FUNCTIONS]"
    Print "DEVICE WII(func)"
   End Select

  Case "m"
   Print "[A]rrays   [M]atrix  [V]ector  [Q]uaternion"
   Print "[F]FT   f[U]nctions            e[X]it"
   Do
    k$=Inkey$
   Loop Until Instr("AaMmVvQqFfUuXx",k$)
   Print
   Select Case LCase$(k$)
   Case "x"
    Exit Sub
   Case "a"
    Print "[Array Commands]"
    Print "MATH SET number, array()"
    Print "MATH SCALE in(), scale, out()"
    Print "MATH ADD in(), number, out()"
    Print "MATH INTERPOLATE in1(), in2(), ratio, out()"
    Print "MATH SLICE sourcearray() [,d1][,d2][,d3][,d4][,d5], destinationarray()"
    Print "MATH INSERT targetarray() [,d1][,d2][,d3][,d4][,d5], sourcearray()"
   Case "m"
    Print "MATH M_INVERSE array!(), inversearray!()"
    Print "MATH M_PRINT array()"
    Print "MATH M_TRANSPOSE in(), out()"
    Print "MATH M_MULT in1(), in2(), out()"
   Case "v"
    Print "MATH V_PRINT array()"
    Print "MATH V_NORMALISE! inV(), outV()"
    Print "MATH V_MULT matrix(), inV(), outV()"
    Print "MATH V_CROSS inV1(), inV2(), outV()"
   Case "q"
    Print "MATH Q_INVERT imQ(), outQ()"
    Print "MATH Q_VECTOR x, y, z, outVQ()"
    Print "MATH Q_CREATE theta, x, y, z, outRQ()"
    Print "MATH Q_EULER yaw, pitch, roll, outRQ()"
    Print "MATH Q_MULT inQ1, inQ2, outQ()"
    Print "MATH Q_ROTATE RQ(), inVQ(), outVQ()"
   Case "f"
    Print "MATH FFT signalarray!(), FFTarray!()"
    Print "MATH FFT INVERSE FFTarray!(), sgnalarray!()"
    Print "MATH FFT MAGNITUDE signalarray!(), magbitudearray!()"
    Print "MATH FFT PHASE signalarray!(), phasearray!()"
   Case "u"
    Print "[Simple]"
    Print "MATH(ATAN3 x, y)"
    Print "MATH(COSH a)"
    Print "MATH(LOG10 a)"
    Print "MATH(SINH a)"
    Print "MATH(TANH a)"
    Print
    Print "[Statistics]"
    Print "MATH(CHI s())"
    Print "MATH(CHI_p s())"
    Print "MATH(CORREL a(), b())"
    Print "MATH(MAX a() [,index%])"
    Print "MATH(MEAN a())"
    Print "MATH(MEDIAN a())"
    Print "MATH(MIN a() [,index%])"
    Print "MATH(SD a())"
    Print "MATH(SUM a())"
    Print
    Print "[Vector]"""
    Print "MATH(MAGNITUDE v())"
    Print "MATH(DOTPRODUCT v1(), v2())"
    Print
    Print "[Matrix]"
    Print "MATH(M_DETERMINANT array!())"
   End Select

  Case "i"
   Print "[DISPLAYS]"
   Print "OPTION RESOLUTION resolution"
   Print
   Print "resolution = 640x480 or resolution = 640"
   Print "MODE 1: 640x480 2 colours. + TILE1   MODE 2: 320x240 16 colours A1"
   Print "MODE 3: 640x480 16 colours C1        MODE 4: 320x240 32768 colours"
   Print "MODE 5: 320x250 256 colours B1"
   Print
   Print "resolution - 1280x720 or resolution = 1280"
   Print "MODE 1: 1280x720 2 colours. + TILE2  MODE 2: 320x180 16 colours A2"
   Print "MODE 3: 640x360 16 colours C2        MODE 5: 320x180 256 colours B"
   Print
   Print "resolution = 1024x768 or resolution = 1024"
   Print "MODE 1: 1024x768 2 colours. + TILE2  MODE 2: 256x192 16 colours A2"
   Print "MODE 3: 512x384 16 colours C2        MODE 5: 256x192 256 colours B"
   Print
   Print "A: Two optional layers, no memory usage"
   Print "B: One optional layer, no memory usage"
   Print "C: One optional layer, significant memory usage"
   Print "1: Colour mapping available to RGB555 palette"
   Print "2: Colour mapping available to RGB332 palette"
  Case "u"
   Print "[UTILITY]"
   Print "Utilities available:"
   Print "[A]SCII character set (in current font)"
   Print "[G]eneric USB gamepad quick test"
   Print "e[X]it"
   Do
    k$=Inkey$
   Loop Until Instr("AaGgXx",k$)
   Print
   Select Case LCase$(k$)
    Case "x"
     Exit Sub
    Case "a"
     Print "[ASCII character set]"
     For i=32 To 255
      Print Str$(i,3)" "Hex$(i,2)"h "Chr$(i)"  ";
      If (i/6) = Int(i/6) Then Print
     Next
    Case "g"
     Print "[Generic Gamepad test]"
     'Local gpchan,bits
     CLS
     Print "Quick and dirty generic gamepad test"
     Do
      Print
       Do
        Input "USB channel of gamepad to be tested: ";gpchan
        gpchan=Int(gpchan)
        If gpchan<1 Or gpchan>4 Then Print "illegal USB channel number. Must be 1-4"
        Print
       Loop Until gpchan>0 And gpchan<5
       a = DEVICE(gamepad gpchan, t)
       If a=0 Then Print "No gamepsd detected!"
     Loop Until a>0
     CLS
    Print "Gamepad reported as type &h"Hex$(a,6)
    Print
    Print "Press a button on the gamepad or a key to end"
    Do
     If Inkey$>"" Then End
     bits = DEVICE(gamepad gpchan, b)
     Print @(100,100)Hex$(bits,4);" ";
     Select Case bits
      Case &h0001 : Print "Right shoulder"
      Case &h0002 : Print "Start         "
      Case &h0004 : Print "Home          "
      Case &h0008 : Print "Select        "
      Case &h0010 : Print "Left shoulder "
      Case &h0020 : Print "Cursor down   "
      Case &h0040 : Print "Cursor right  "
      Case &h0080 : Print "Cursor up     "
      Case &h0100 : Print "Cursor left   "
      Case &h0400 : Print "Button X      "
      Case &h0800 : Print "Button A      "
      Case &h1000 : Print "Button Y      "
      Case &h2000 : Print "Button B      "
      Case &h0000 : Print "                              "
      Case Else
       Print "Multi: ";Bin$(bits,16)
     End Select
     Pause 100
    Loop
   End Select
End Select

End Sub
